/**********
* File: DXGraphics.h

* Brief Description: This file is the master header file of RoboDXGL framework.
					 
* Written By: Shilpa Prabhu 

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 15Oct04

* Change History (Most Recent First):

**********/


#ifndef _DXGRAPHICS_H_
#define _DXGRAPHICS_H_

#include <Carbon/Carbon.h>
#include <AGL/agl.h>
#include "WinDataTypes.h"
#ifdef DXGRAPHICS_VERSION8
#include "d3d8.h"
#include "d3dx8.h"  
#endif
#ifdef DXGRAPHICS_VERSION9
#include "d3d9.h"
#include "d3dx9.h" 
#endif
#include "DXGraphicsUtils.h" 



#ifdef _DEBUG //define this in a separate pch file for debug target.
#define GL_DEBUG_TRY()	{ GLenum __err = glGetError(); }
#define GL_DEBUG_CATCH() { GLenum __err = glGetError(); if (__err ) { MESG("%s(%d): %s\n", __FILE__, __LINE__, GL_GetErrorString(__err)); {__asm int 3}}}
//#define GL_DEBUG_CATCH() SYS_ASSERT(GL_NO_ERROR == glGetError())
#else
#define GL_DEBUG_TRY()
#define GL_DEBUG_CATCH()
#endif

//shilpa on 26 Oct 04 - brought this code from dxglver.h of RVR code - from here.
enum {
	DXGL_OPTION_NOTEXTURE =	 0x1,
	DXGL_OPTION_NOFILL	  =  0x2,
	DXGL_OPTION_DEBUG	  =  0x4,
	DXGL_OPTION_16BIT	  =  0x8
};

/*extern int		dxgl_option;
extern int		DXGL_ReadOptions(void);*/
//shilpa on 26 Oct 04 - brought this code from dxglver.h of RVR code - till here.


// bala : adding the following stuctures

struct PixelTag 
{
	enum _D3DFORMAT	Format;
	int				dwSize;
	GLint 			internalFmt;
	GLenum 			textureFmt;
	GLenum			textureType;
};


#endif //_DXGRAPHICS_H_


